%  Description: This function decodes and returns a series of quantized
%  vectors. The file assumes the data format of the related encode function.
% 
%  Call Syntax: VECTORS = decode(CodeBook,infile,Params)
% 
%  Input Arguments:
% 	Name: infile
% 	Type: string 
% 	Description: name of file to be decoded.
% 
% 	Name: CoeffGroups
% 	Type: cellarray
% 	Description: A 1xN cell array in which the n'th cell contains a list of
% 	coeffecients that are elements of the n'th group.
% 
% 	Name: GroupBits
% 	Type: vector
% 	Description: a 1xN vector containing the number of bits the n'th group
% 	is to be coded with.
% 
% 	Name: ReconstructionLvls
% 	Type: cellarray 
% 	Description: A 1xN cell array in which the n'th cell contains the
% 	reconstruction levels of the n'th group.
% 
%  Output Arguments: 
% 	Name: VECTORS
% 	Type: matrix (D-dimensional vector X number of vectors)
% 	Description: A matrix of feature vectors to be quantized, each feature 
%    vector should be one column of the matrix.
% 
%  Creation Date:
%  Last Revision:
% 
%  Required subroutines: 
% 
%  Notes:
% 
%  References:
% *************************************************************************
%
